chorizo-config(5)

# NAME
_chorizo.ini_ - configuration file for *chorizo*(1)

# DESCRIPTION
_chorizo.ini_ is the system configuration file for the chorizo browser. The syntax
is the standard GTK ini format. An example is provided at
_/usr/share/doc/chorizo/chorizo.ini_, and user configuration should go in
_~/.config/chorizo/chorizo.ini_, or your equivalent as set by
$XDG_CONFIG_DIR. Settings must go under the relevant subsection.

# OPTIONS
## BROWSER
*console_to_stdout*++
	Type: boolean++
	Default: false++
	Print the contents of the browser console to stdout.

*cookie_policy*++
	Type: string++
	Default: "no_third_party"++
	Options: "all", "none", "no_third_party"++
	Determines what cookies are accepted.

*history_file*++
	Type: string++
	Default: none++
	File that chorizo should save history to.

*homepage*++
	Type: string++
	Default: "about:blank"++
	Set the default URI for new tabs.

*images_enabled*++
	Type: boolean++
	Default: true++
	Determines whether or not images are enabled by default.

*javascript_can_access_clipboard*++
	Type: boolean++
	Default: false++
	Determines whether or not JavaScript can access the clipboard. Necessary for
	websites like gDrive, and "click to copy" buttons

*javascript_enabled*++
	Type: boolean++
	Default: true++
	Determines whether or not JavaScript is enabled by default.

*search_engine*++
	Type: string++
	Default: "https://duckduckgo.com?q="++
	What search engine to use when searching with "w/".

*spellcheck_enabled*++
	Type: boolean++
	Default: true++
	Disable spell checking.

*spellcheck_language*++
	Type: string++
	Default: "en_US;"++
	Language to use for spell checking.

*user_agent*++
	Type: string++
	Default: the WebKit default++
	Choose a custom user agent.

*webgl_enabled*++
	Type: boolean++
	Default: true++
	Determines whether or not WebGL is enabled.

## UI
*default_uri*++
	Type: string++
	Default: "https://"++
	The URI to fill the location bar with when entering the it from the homepage.

*font_family_default*++
	Type: string++
	Default: "sans-serif"++
	Default font family.

*font_family_default_monospace*++
	Type: string++
	Default: "monospace"++
	Default monospace font family

*font_family_default_sans_serif*++
	Type: string++
	Default: "sans-serif"++
	Default sans-serif font family

*font_family_default_serif*++
	Type: string++
	Default: "serif"++
	Default serif font family

*font_size_default*++
	Type: integer++
	Default: 16++
	Default font size.

*font_size_default_monospace*++
	Type: integer++
	Default: 13++
	Default monospace font size.

*scroll_lines*++
	Type: integer++
	Default: 3++
	Number of lines to scroll in the "scroll_lines_\*" keybindings.

*tab_width*++
	Type: integer++
	Default: 20++
	Width of each tab in characters.

*zoom_level*++
	Type: double++
	Default: 1.0++
	Default zoom level of each page.

## KEYBINDINGS
All of these keybindings are bound to Control + key.

*download_manager*++
	Type: string++
	Default: y++
	Toggle the download manager.

*history_back*++
	Type: string++
	Default: h++
	Go back in history.

*history_forwards*++
	Type: string++
	Default: h++
	Go forwards in history.

*location*++
	Type: string++
	Default: t++
	Select the URL.

*print*++
	Type: string++
	Default: Print++
	Print the current page

*quit*++
	Type: string++
	Default: g++
	Deselect everything and focus on the webpage.

*reload*++
	Type: string++
	Default: e++
	Reload the current tab.

*scroll_line_down*++
	Type: string++
	Default: j++
	Scroll down one line.

*scroll_line_up*++
	Type: string++
	Default: k++
	Scroll up one line.

*scroll_page_down*++
	Type: string++
	Default: f++
	Scroll down one page.

*scroll_page_up*++
	Type: string++
	Default: b++
	Scroll up one page.

*search_backwards*++
	Type: string++
	Default: r++
	Search in-page backwareds.

*search_forwards*++
	Type: string++
	Default: s++
	Search in-page forwards.

*tab_close*++
	Type: string++
	Default: q++
	Close the current tab.

*tab_switch_[1-9]*++
	Type: string++
	Default: [1-9]++
	Group of options to jump to a particular tab, numbered from the left. Set
	these separately from each other.

*tab_previous*++
	Type: string++
	Default: u++
	Focus the previous tab.

*tab_mute*++
	Type: string++
	Default: AudioMute++
	Mute the current tab.

*tab_new*++
	Type: string++
	Default: w++
	Open a new tab.

*tab_next*++
	Type: string++
	Default: i++
	Focus the next tab.

*toggle_js*++
	Type: string++
	Default: o++
	Toggle JavaScript.

*toggle_img*++
	Type: string++
	Default: NULL++
	Toggle image loading.

*web_search*++
	Type: string++
	Default: d++
	Start a web search.

*zoom_in*++
	Type: string++
	Default: =++
	Zoom in 10%.

*zoom_out*++
	Type: string++
	Default: -++
	Zoom out 10%.

*zoom_reset*++
	Type: string++
	Default: -++
	Reset zoom to default.
