chorizo(1)

# NAME
chorizo - simple web browser

# SYNOPSIS
*chorizo* - [-C] [_URI ..._]

# DESCRIPTION
*chorizo* is a simple web browser using GTK+ 3, GLib and WebKit2GTK+.

# OPTIONS
In addition to the standard arguments of GTK+ 3, *chorizo* knows about the
following options:

*-C*
	Disables cooperative instances.

*-p*
	Launch a private window.

*-v*
	Print version and exit.

After these options there can be any number of URIs specified to open.

# ENVIRONMENT
In addition to the standard variables of GTK+ 3, *chorizo* knows about the
following environment variable:

*CHORIZO_FIFO_SUFFIX*
	Cooperative instances are implemented using a named pipe in the file
	system. The name of this pipe usually is (at least on modern systems following
	XDG standards: /var/run/user/$UID/chorizo.fifo-$CHORIZO_FIFO_SUFFIX

	*$UID* is the id of your user. *$CHORIZO_FIFO_SUFFIX* defaults to *main*. If you
	change this variable, you can launch several independent cooperative instances
	of *chorizo*.

# FILES
XDG variables will be used to construct these paths.
*~/.config/chorizo/chorizo.ini*
	Configuration file. See *chorizo-config*(5).

*~/.config/chorizo/adblock*
	Adblock patterns. See *chorizo-usage*(1).

*~/.local/share/chorizo/certs*
	Directory where trusted certificates are stored. See *chorizo-usage*(1).

*~/.local/share/chorizo/cookies.db*
	Database where cookies are stored. It is kept in the same format as Firefox,
	so the file can easily be copied over.

*~/.local/share/chorizo/user-scripts*
	Directory to store user-supplied JavaScript snippets. See *chorizo-usage*(1).

*~/.local/share/chorizo/user-styles*
	Directory to store user-supplied CSS snippets. See *chorizo-usage*(1).

*~/.local/share/chorizo/web_extensions*
	Sets the directory where WebKit will look for web extensions. See
	*chorizo-usage*(1).

*~/.cache/chorizo*
*~/.cache/webkitgtk*
	General caches.

*~/.local/share/webkitgtk*
	WebKitGTK will dump its caches and local storage here. It is probably wise to
	clean those directories regularly or to mount them as *tmpfs*(5).

# LICENSE
*chorizo* is released under the MIT license. See the accompanying LICENSE file.

# HISTORY
chorizo is a fork of the lariza browser by Peter Hofmann. The project was
started in June 2014. This fork is maintained by Armaan Bhojwani.

# SEE ALSO
*chorizo-usage*(1), *chorizo-config*(5)
