#!/usr/bin/perl

use strict;
use warnings;

use CGI qw/:standard/;
use DBI;
use DBIx::XHTML_Table;

use File::Basename;
use lib dirname (__FILE__);
use Heliometric;

my $cgi = new CGI;
print $cgi->header();

Heliometric::top();

my $dbh = Heliometric::db_connect;
my $sth;
my $query;

print "<h2>Yearbook Admin Panel</h2>";
print "<h3>Submissions</h3>";

$query = << "EOF";
SELECT date, username, comment,
printf("<a href=""/~yearbook/download.pl?img=%s"">%s</a>", sha256, filename)
FROM submissions;'
EOF

$sth = $dbh->prepare($query);
$sth->execute();
 
my $headers = ["Date", "Username", "Comment", "Link"];
my $rows    = $sth->fetchall_arrayref();
 
print DBIx::XHTML_Table->new($rows,$headers)->output();

print "<h3>Captains Messages</h3>";

$query = << "EOF";
SELECT * FROM messages;'
EOF

$sth = $dbh->prepare($query);
$sth->execute();
 
my $headers = ["Date", "Username", "Team", "Message"];
my $rows    = $sth->fetchall_arrayref();

print DBIx::XHTML_Table->new($rows,$headers)->output();
 
Heliometric::bottom();
