#!/usr/bin/perl

use strict;
use warnings;

use CGI qw/:standard/;

use File::Basename;
use lib dirname (__FILE__);
use Heliometric;

my $cgi = new CGI;
print $cgi->header();

Heliometric::top();

my @teams;
open(my $fh, "<", "/data/yearbook/teams")
        or quit();
while(<$fh>) {
    chomp;
    push @teams, $_;
}
close $fh;

print << "EOF";
<h2 id="submit">Captains Messages</h2>

<form action="captains-submit.pl" method="post" enctype="multipart/form-data">

<p>
<label for="username">
	Nobles username
	<span class="required">*</span>
</label>
<br>
<input type="text" name="username" id="username" required>

<p>
<label for="team">
	Team name
	<span class="required">*</span>
</label>
<br>
<select id="team" name="team">
EOF

foreach (@teams) {
	print option({value => "$_"}, $_);
}

print << "EOF";
</select>

<p>
<label for="message">
	What is your message?
	<span class="required">*</span>
</label>
<br>
<textarea name="message" id="message"></textarea>

<p>
<input type="submit">

</form>
EOF

Heliometric::bottom();
