#!/usr/bin/perl

use strict;
use warnings;

use CGI qw/:standard/;
use DBI;
use POSIX qw(strftime);
use Digest::SHA qw(sha256);

use File::Basename;
use lib dirname (__FILE__);
use Heliometric;

my $cgi = new CGI;
print $cgi->header();

Heliometric::top();

print "<h2>Photo Submissions</h2>";

if ($cgi->param('password') ne "yearbookphotos2122") {
	print "<p>ERROR: Wrong password.";
	Heliometric::quit();
}

my $comment = $cgi->param('comment');
my $username = lc $cgi->param('username');
Heliometric::check_username($username);

my $dbh = Heliometric::db_connect();

my $query = << "EOF";
CREATE TABLE IF NOT EXISTS submissions (
date text,
username text,
comment text,
filename text,
mime text,
image blob,
sha256 text
);
EOF

$dbh->do($query);

my @uploads = $cgi->upload('upload');

foreach my $fh (@uploads) {
	if (defined $fh) {
		if ( -s $fh < 10000000) {
		my $time = strftime('%Y-%m-%dT%H:%M:%SZ' , gmtime(time()));
		my $mime = $cgi->uploadInfo($fh)->{'Content-Type'};

		$query = << "EOF";
INSERT INTO submissions
VALUES (
"$time",
"$username",
"$comment",
"$fh",
"$mime",
?,
?
);
EOF
		my $sth = $dbh->prepare($query);

		my ($image, $buf);
			while(read $fh, $buf, 1024) {
			$image .= $buf;
		}
		$sth->bind_param(1, $image, DBI::SQL_BLOB);
		$sth->bind_param(2, unpack("H*", sha256($image)));
		$sth->execute();
	} else {
		print "<p>NOTICE: File $fh too large. Skipped.\n"
	}
	}
}
$dbh->disconnect;

print << "EOF";
<p>Thank you for submitting, $username!</p>
EOF

Heliometric::bottom();
